/* ErrorFunctions.cpp */

#include "fp.h"

// see 7.1.21 in Handbook of Mathematical Functions
bool myErf(fp& z, fp& x)
{
	fp				res;
	INT32			p;
	static fp		one, onePointFive;
	static bool		initGood=false;
	bool			isConverged;
	
	if(!initGood)
	{
		one = 1;
		onePointFive = 3.;
		onePointFive.e--;
		initGood = true;
	}
		
	if(abs(x)>=1000)
	{
		isConverged = myErfc(res, x);
		z = one - res;
		return isConverged;
	}
	
	p = getBlockPrec();
	setBlockPrec(p+1);
	
	isConverged = kummerM(res, one, onePointFive, x*x);
	z = res*2.*x*exp(-x*x)/sqrt(Pi());
			
	setBlockPrec(p);
	
	return isConverged;
	
}/* myErf */


bool myErfc(fp& z, fp& x)
{
	fp				res;
		
	if(abs(x)<1000)
	{
		if(myErf(res, x))
		{
			z = 1. - res;
			return true;
		}
		else
		{
			z = 1. - res;
			return false;
		}
	}
	
	// now abs(x)>=1000
	return asymptoticErfc(z, x);
	
}/* myErfc */

// 7.1.23 only holds for x>0
bool asymptoticErfc(fp& z, fp& x)
{
	INT32		n;
	fp			f, fLast;
	fp			thisTerm, lastTerm;
	fp			TwoxSquared;
	bool		precisionGood;
	
	TwoxSquared = 2*x*x;
	
	f = 1.;
	fLast = 1.;
	lastTerm = 1.;
	for(n=1; ;n++)
	{
		thisTerm = -lastTerm*(2*n-1)/TwoxSquared;
		f = f + thisTerm;
		
		if(f==fLast)
		{
			precisionGood = true;
			break;
		}
		
		if(abs(thisTerm)>=abs(lastTerm))
		{
			precisionGood = false;
			break;
		}
		
		lastTerm = thisTerm;
		fLast = f;
	}
	
	z = f*exp(-x*x)/(x*sqrt(Pi()));
	
	return precisionGood;
	
}/* asymptoticErfc */
